/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.system.dto.MYakusyokuDto;

public class MYakusyokuDao extends BaseDao {

	// e[uyуL[
	public static final String TABLE	= "M_YAKUSYOKU";
	public static final String KEY_1 	= "YCODE";		//ER[h
	public static final String KEY_2 	= "TOKYU";		//

	// 
	public static final String COL_YCODE  		= "YCODE";		//ER[h
	public static final String COL_YNAME  		= "YNAME";		//E
	public static final String COL_TOKYU  		= "TOKYU";		//
	public static final String COL_TKEKKIN  		= "TKEKKIN";	//ʋxɍTL
	public static final String COL_KEKKIN  		= "KEKKIN";		//ʌ΍TL
	public static final String COL_SKEKKIN  		= "SKEKKIN";	//a΍TL
	public static final String COL_TIJI  			= "TIJI";		//xލTL
	public static final String COL_ZAJI  			= "ZAJI";		//ʎcƎ蓖L
	public static final String COL_KSJI  			= "KSJI";		//xcƎ蓖L
	public static final String COL_SNJI  			= "SNJI";		//[cƎ蓖L
	public static final String COL_KAIKIN  		= "KAIKIN";		//FΎ蓖L
	public static final String COL_SYOKUJI 	 	= "SYOKUJI";	//H蓖L
	public static final String COL_CYOKU1  		= "CYOKU1";		//1蓖L
	public static final String COL_CYOKU2  		= "CYOKU2";		//2蓖L
	public static final String COL_CYOKU3  		= "CYOKU3";		//3蓖L
	public static final String COL_HOKA1  		= "HOKA1";		//̑x1L
	public static final String COL_HOKA2  		= "HOKA2";		//̑x2L
	public static final String COL_HOKA3  		= "HOKA3";		//̑x3L
	public static final String COL_HOKA4  		= "HOKA4";		//̑x4L
	public static final String COL_HOKA5  		= "HOKA5";		//̑x5L
	public static final String COL_TKEKKINTAN  	= "TKEKKINTAN";	//ʋxɍTP
	public static final String COL_KEKKINTAN  	= "KEKKINTAN";	//ʌ΍TP
	public static final String COL_SKEKKINTAN  	= "SKEKKINTAN";	//a΍TP
	public static final String COL_TIJITAN  		= "TIJITAN";	//xލTP
	public static final String COL_ZAJITAN  		= "ZAJITAN";	//ʎcƎ蓖P
	public static final String COL_KSJITAN  		= "KSJITAN";	//xcƎ蓖P
	public static final String COL_SNJITAN  		= "SNJITAN";	//[cƎ蓖P
	public static final String COL_KAIKINTAN  	= "KAIKINTAN";	//FΎ蓖P
	public static final String COL_SYOKUJITAN  	= "SYOKUJITAN";	//H蓖P
	public static final String COL_CYOKU1TAN  	= "CYOKU1TAN";	//1蓖P
	public static final String COL_CYOKU2TAN  	= "CYOKU2TAN";	//2蓖P
	public static final String COL_CYOKU3TAN  	= "CYOKU3TAN";	//3蓖P
	public static final String COL_HOKA1TAN  		= "HOKA1TAN";	//̑x1P
	public static final String COL_HOKA2TAN  		= "HOKA2TAN";	//̑x2P
	public static final String COL_HOKA3TAN  		= "HOKA3TAN";	//̑x3P
	public static final String COL_HOKA4TAN  		= "HOKA4TAN";	//̑x4P
	public static final String COL_HOKA5TAN  		= "HOKA5TAN";	//̑x5P

	/**
	 * RXgN^
	 */
	public MYakusyokuDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<MYakusyokuDto> mappingAll() throws SQLException {
		List<MYakusyokuDto> all = new ArrayList<MYakusyokuDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return m_yakusyokuDto m_yakusyokuR[h
	 * @throws SQLException
	 */
	private MYakusyokuDto mapping() throws SQLException {
		MYakusyokuDto dto = new MYakusyokuDto();
		dto.setYCode 		(rs.getString (COL_YCODE  ));		//ER[h
		dto.setYName 		(rs.getString (COL_YNAME  ));		//E
		dto.setTokyu 		(rs.getString (COL_TOKYU  ));		//
		dto.setTKekkin 		(rs.getString (COL_TKEKKIN  ));		//ʋxɍTL
		dto.setKekkin 		(rs.getString (COL_KEKKIN  ));		//ʌ΍TL
		dto.setSKekkin 		(rs.getString (COL_SKEKKIN  ));		//a΍TL
		dto.setTiJi 		(rs.getString (COL_TIJI  ));		//xލTL
		dto.setZaJi 		(rs.getString (COL_ZAJI  ));		//ʎcƎ蓖L
		dto.setKsJi 		(rs.getString (COL_KSJI  ));		//xcƎ蓖L
		dto.setSnJi 		(rs.getString (COL_SNJI  ));		//[cƎ蓖L
		dto.setKaikin 		(rs.getString (COL_KAIKIN  ));		//FΎ蓖L
		dto.setSyokuji 		(rs.getString (COL_SYOKUJI ));		//H蓖L
		dto.setCyoku1 		(rs.getString (COL_CYOKU1  ));		//1蓖L
		dto.setCyoku2 		(rs.getString (COL_CYOKU2  ));		//2蓖L
		dto.setCyoku3 		(rs.getString (COL_CYOKU3  ));		//3蓖L
		dto.setHoka1 		(rs.getString (COL_HOKA1  ));		//̑x1L
		dto.setHoka2 		(rs.getString (COL_HOKA2  ));		//̑x2L
		dto.setHoka3 		(rs.getString (COL_HOKA3  ));		//̑x3L
		dto.setHoka4 		(rs.getString (COL_HOKA4  ));		//̑x4L
		dto.setHoka5 		(rs.getString (COL_HOKA5  ));		//̑x5L
		dto.setTKekkinTan 	(rs.getInt    (COL_TKEKKINTAN  ));	//ʋxɍTP
		dto.setKekkinTan 	(rs.getInt    (COL_KEKKINTAN  ));	//ʌ΍TP
		dto.setSKekkinTan 	(rs.getInt    (COL_SKEKKINTAN  ));	//a΍TP
		dto.setTiJiTan 		(rs.getInt    (COL_TIJITAN  ));		//xލTP
		dto.setZaJiTan 		(rs.getInt    (COL_ZAJITAN  ));		//ʎcƎ蓖P
		dto.setKsJiTan 		(rs.getInt    (COL_KSJITAN  ));		//xcƎ蓖P
		dto.setSnJiTan 		(rs.getInt    (COL_SNJITAN  ));		//[cƎ蓖P
		dto.setKaikinTan 	(rs.getInt    (COL_KAIKINTAN  ));	//FΎ蓖P
		dto.setSyokuJiTan 	(rs.getInt    (COL_SYOKUJITAN  ));	//H蓖P
		dto.setCyoku1Tan 	(rs.getInt    (COL_CYOKU1TAN    ));	//1蓖P
		dto.setCyoku2Tan 	(rs.getInt    (COL_CYOKU2TAN  ));	//2蓖P
		dto.setCyoku3Tan 	(rs.getInt    (COL_CYOKU3TAN  ));	//3蓖P
		dto.setHoka1Tan 	(rs.getInt    (COL_HOKA1TAN  ));	//̑x1P
		dto.setHoka2Tan 	(rs.getInt    (COL_HOKA2TAN  ));	//̑x2P
		dto.setHoka3Tan 	(rs.getInt    (COL_HOKA3TAN  ));	//̑x3P
		dto.setHoka4Tan 	(rs.getInt    (COL_HOKA4TAN  ));	//̑x4P
		dto.setHoka5Tan 	(rs.getInt    (COL_HOKA5TAN  ));	//̑x5P
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MYakusyokuDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<MYakusyokuDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * Sf[^擾(L̂)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MYakusyokuDto> findAvailable() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_TOKYU);
			sb.append(" > '0' ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			List<MYakusyokuDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * Sf[^擾(̂)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MYakusyokuDto> findForTitle() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE NOT (");
			sb.append(COL_TOKYU);
			sb.append(" > '0' )");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			List<MYakusyokuDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾
	 * @param ycode ER[h(L[)
	 * @param tokyu (L[)
	 * @return m_yakusyokuDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MYakusyokuDto findForKey(
			String ycode,
			String tokyu
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, ycode);
			setParam(index++, tokyu);
			executeQuery();
			MYakusyokuDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param ycode ER[h(L[)
	 * @param tokyu (L[)
	 * @return m_yakusyokuDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MYakusyokuDto findForUpdate(
			String ycode,
			String tokyu
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, ycode);
			setParam(index++, tokyu);
			executeQuery();
			MYakusyokuDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param ycode ER[h
	 * @param tokyu 
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String ycode,
			String tokyu
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_YCODE  );
		sb.append(" = ? AND ");
		sb.append(COL_TOKYU  );
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   ycode  );
			setParam(index++,   tokyu   + "%");
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param ycode ER[h
	 * @param tokyu 
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String ycode,
			String tokyu,
			String yname
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_YCODE  );
		sb.append(" LIKE ? AND ");
		sb.append(COL_TOKYU  );
		sb.append(" LIKE ? AND ");
		sb.append(COL_YNAME  );
		sb.append(" LIKE ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, 		ycode + "%" );
			setParam(index++, 		tokyu + "%" );
			setParam(index++, "%" + yname + "%" );
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}	

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(MYakusyokuDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto,true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(MYakusyokuDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto,false);
			setParam(index++, dto.getYCode());
			setParam(index++, dto.getTokyu());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(MYakusyokuDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getYCode());
			setParam(index++, dto.getTokyu());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @throws SQLException
	 */
	private void setParams(MYakusyokuDto dto,boolean isInsert) throws SQLException {
		setParam(index++, dto.getYCode());		//ER[h
		setParam(index++, dto.getYName());		//E
		setParam(index++, dto.getTokyu());		//
		setParam(index++, dto.getTKekkin());	//ʋxɍTL
		setParam(index++, dto.getKekkin());		//ʌ΍TL
		setParam(index++, dto.getSKekkin());	//a΍TL
		setParam(index++, dto.getTiJi());		//xލTL
		setParam(index++, dto.getZaJi());		//ʎcƎ蓖L
		setParam(index++, dto.getKsJi());		//xcƎ蓖L
		setParam(index++, dto.getSnJi());		//[cƎ蓖L
		setParam(index++, dto.getKaikin());		//FΎ蓖L
		setParam(index++, dto.getSyokuji());	//H蓖L
		setParam(index++, dto.getCyoku1());		//1蓖L
		setParam(index++, dto.getCyoku2());		//2蓖L
		setParam(index++, dto.getCyoku3());		//3蓖L
		setParam(index++, dto.getHoka1());		//̑x1L
		setParam(index++, dto.getHoka2());		//̑x2L
		setParam(index++, dto.getHoka3());		//̑x3L
		setParam(index++, dto.getHoka4());		//̑x4L
		setParam(index++, dto.getHoka5());		//̑x5L
		setParam(index++, dto.getTKekkinTan());	//ʋxɍTP
		setParam(index++, dto.getKekkinTan());	//ʌ΍TP
		setParam(index++, dto.getSKekkinTan());	//a΍TP
		setParam(index++, dto.getTiJiTan());	//xލTP
		setParam(index++, dto.getZaJiTan());	//ʎcƎ蓖P
		setParam(index++, dto.getKsJiTan());	//xcƎ蓖P
		setParam(index++, dto.getSnJiTan());	//[cƎ蓖P
		setParam(index++, dto.getKaikinTan());	//FΎ蓖P
		setParam(index++, dto.getSyokuJiTan());	//H蓖P
		setParam(index++, dto.getCyoku1Tan());	//1蓖P
		setParam(index++, dto.getCyoku2Tan());	//2蓖P
		setParam(index++, dto.getCyoku3Tan());	//3蓖P
		setParam(index++, dto.getHoka1Tan());	//̑x1P
		setParam(index++, dto.getHoka2Tan());	//̑x2P
		setParam(index++, dto.getHoka3Tan());	//̑x3P
		setParam(index++, dto.getHoka4Tan());	//̑x4P
		setParam(index++, dto.getHoka5Tan());	//̑x5P
		setCommonParams(isInsert);
	}

	/**
	 * EʃR[hoSQL擾
	 * @return f[^xEʃR[hoSQL
	 */
	public static String getForLowerLevel() {
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(COL_YCODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(COL_YCODE + " >= ? ");
		return sb.toString();
	}

}
